/**
 * WordPress dependencies
 */
import { Button, Panel, PanelBody, TextareaControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

/**
 * Image generation panel.
 *
 * @param {Function} generateImage  Generate image.
 * @param {string}   imagePrompt    Image prompt.
 * @param {boolean}  processing     Processing state.
 * @param {Function} setImagePrompt Set image prompt.
 *
 * @return {JSX.Element} Image generation panel.
 */
const ImagesPanel = ( { generateImage, imagePrompt, processing, setImagePrompt } ) => {
	return <Panel>
		<PanelBody title={ __( 'Generate images', 'fuzion' ) }>
			<TextareaControl
				disabled={ processing }
				help={ __( 'Describe your desired image', 'fuzion' ) }
				label={ __( 'Prompt', 'fuzion' ) }
				onChange={ ( value ) => setImagePrompt( value ) }
				value={ imagePrompt }
			/>
			<Button
				disabled={ processing || ! imagePrompt }
				isBusy={ processing }
				onClick={ generateImage }
				text={ processing ? __( 'Generating...', 'fuzion' ) : __( 'Generate image', 'fuzion' ) }
				variant="secondary"
			/>
		</PanelBody>
	</Panel>;
};

export default ImagesPanel;
