/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { Button, TextareaControl, RangeControl } from '@wordpress/components';

/**
 * Internal dependencies
 */
import { contentActions } from '../../../../misc/actions';

/**
 * Content type slide.
 *
 * @param {boolean}  processing
 * @param {string}   type
 * @param {string}   prompt
 * @param {Function} setPrompt
 * @param {Function} processGenerate
 * @param {Function} nextSlide
 * @return {JSX.Element} Settings panel.
 */
const Prompt = ( { processing, type, prompt, credits, temperature, results, setPrompt, setCredits, setTemperature, setResults, processGenerate } ) => {
	return (
		<>
			<RangeControl
				label={ __( 'Maximum credits per request', 'fuzion' ) }
				value={ credits }
				onChange={ ( value ) => setCredits( value ) }
				min={ 1 }
				max={ 2048 }
			/>
			{ 'code_generate' !== type &&
				<RangeControl
					label={ __( 'Creativity level', 'fuzion' ) }
					value={ temperature }
					onChange={ ( value ) => setTemperature( value ) }
					min={ 0 }
					max={ 100 }
				/>
			}
			{ 'code_generate' !== type &&
				<RangeControl
					label={ __( 'Number of results per request', 'fuzion' ) }
					value={ results }
					onChange={ ( value ) => setResults( value ) }
					min={ 1 }
					max={ 3 }
				/>
			}
			<TextareaControl
				disabled={ processing }
				help={ contentActions[ type ]?.help }
				label={ __( 'Prompt', 'fuzion' ) }
				onChange={ ( value ) => setPrompt( value ) }
				placeholder={ contentActions[ type ]?.placeholder }
				value={ prompt }
			/>
			<Button
				disabled={ processing || ! prompt }
				isBusy={ processing }
				onClick={ processGenerate }
				text={ __( 'Generate', 'fuzion' ) }
				variant="secondary"
			/>
		</>
	);
};

export default Prompt;
