/**
 * WordPress dependencies
 */
import { Icon } from '@wordpress/icons';

/**
 * Internal dependencies
 */
import { contentActions } from '../../../../misc/actions';

/**
 * Content type slide.
 *
 * @param {Function} setType
 * @param {Function} nextSlide
 * @return {JSX.Element} Settings panel.
 */
const ContentTypes = ( { setType, nextSlide } ) => {
	const onActionSelect = ( action ) => {
		setType( action );
		nextSlide();
	};

	return (
		<div className="content-type-cards">
			{ Object.entries( contentActions ).map( ( el ) => {
				return (
					// eslint-disable-next-line
					<div className="content-type-card" key={ el[ 0 ] } onClick={ () => onActionSelect( el[ 0 ] ) }>
						<h4 className="content-type-title" >
							<Icon icon={ el[ 1 ].icon } />
							{ el[ 1 ].name }
						</h4>
						<p className="content-type-desc">{ el[ 1 ].description }</p>
					</div>
				);
			} ) }
		</div>
	);
};

export default ContentTypes;
