/**
 * WordPress dependencies
 */
import { dispatch } from '@wordpress/data';
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import { getLink } from '../modules/utils';

/**
 * Show notice.
 *
 * @since 1.0.0
 * @param {string} error
 */
export const showError = ( error ) => {
	const options = {
		id: 'fuzion-error'
	};

	if ( 'undefined' === typeof error ) {
		return;
	}

	// Most likely, an issue with the API key.
	if ( error.includes( 'API key' ) ) {
		options.actions = [
			{
				url: getLink( 'updatedApiKey' ),
				label: __( 'Update API key', 'fuzion' )
			},
		];
	}

	dispatch( 'core/notices' ).createErrorNotice( error, options );
};
