/**
 * WordPress dependencies
 */
import { addFilter } from '@wordpress/hooks';
import { Fragment } from '@wordpress/element';
import { registerPlugin } from '@wordpress/plugins';

/**
 * Internal dependencies
 */
import '../scss/editor.scss';
import API from './modules/api';
import FuzionIcon from '../../img/icon.svg';
import AIPluginSidebarMoreMenuItem from './slots/plugin-sidebar-more-menu-item';
import AIPluginSidebar from './slots/plugin-sidebar';
import { withDropdownControls } from './slots/toolbar-dropdown';

/**
 * GutenbergEditor class.
 *
 * @since 1.0.0
 */
class GutenbergEditor {
	/**
	 * Register the plugin sidebar in the Gutenberg Editor via the Plugin Sidebar API.
	 *
	 * @since 1.0.0
	 */
	init() {
		registerPlugin(
			'fuzion',
			{
				render: this.combinedBlocks,
				icon: <FuzionIcon width="20px" height="20px" />
			}
		);

		addFilter(
			'editor.BlockEdit',
			'fuzion/with-inspector-controls',
			withDropdownControls
		);
	}

	/**
	 * Get all the combined blocks.
	 *
	 * @since 1.0.0
	 * @return {JSX.Element} Set of blocks.
	 */
	combinedBlocks() {
		const api = new API();
		return (
			<Fragment>
				<AIPluginSidebarMoreMenuItem />
				<AIPluginSidebar api={ api } />
			</Fragment>
		);
	}
}

jQuery( document ).ready( function() {
	window.FuzionEditor = new GutenbergEditor();
	window.FuzionEditor.init();
} );
