/**
 * Internal dependencies
 */
import Chart from 'chart.js/auto';

/**
 * Percentage chart.
 *
 * @param {number} value
 * @param {string} elementID
 */
export const percentageChart = ( value, elementID ) => {
	/**
	 * Calculate number of bars to highlight.
	 *
	 * @param {number} index Current bar index.
	 * @return {string} HEX color.
	 */
	const highlightColor = ( index ) => {
		return 39 * value >= index ? '#6366f1' : '#d1d5db';
	};

	/**
	 * Generate dataset. Make sure the current value is highlighted with a bigger bar.
	 *
	 * @return {any[]} Dataset.
	 */
	const dataset = () => {
		const data = Array( 40 ).fill( [ 0, 15 ] );

		const index = Math.ceil( 39 * value );

		data[ index - 1 ] = [ -7, 22 ];

		return data;
	};

	const chartExists = Chart.getChart( elementID );
	if ( chartExists ) {
		chartExists.destroy();
	}

	const chart = document.getElementById( elementID ).getContext( '2d' );
	new Chart( chart, {
		type: 'bar',
		data: {
			labels: dataset(),
			datasets: [ {
				backgroundColor: ( el ) => highlightColor( el.dataIndex ),
				data: dataset(),
			} ]
		},
		options: {
			barThickness: 2,
			plugins: {
				legend: {
					display: false
				},
				tooltip: {
					enabled: false
				}
			},
			scales: {
				x: {
					display: false,
				},
				y: {
					display: false,
				}
			},
		},
	} );
};
