/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

/**
 * Internal dependencies
 */
import Chart from 'chart.js/auto';

/**
 * Mobile vs Desktop chart.
 *
 * @param {number} percentMobileSearches
 * @param {number} percentDesktopSearches
 */
export const mobileVsDesktopChart = ( percentMobileSearches, percentDesktopSearches ) => {
	const chartExists = Chart.getChart( 'mobileVsDesktop' );
	if ( chartExists ) {
		chartExists.destroy();
	}

	const el = document.getElementById( 'mobileVsDesktop' ).getContext( '2d' );
	new Chart( el, {
		type: 'doughnut',
		data: {
			labels: [ __( 'Desktop', 'fuzion' ), __( 'Mobile', 'fuzion' ) ],
			datasets: [
				{
					data: [ 100 * percentDesktopSearches, 100 * percentMobileSearches ],
					backgroundColor: [
						'#6366f1',
						'rgb(45, 212, 191)',
					],
				}
			]
		},
		options: {
			borderWidth: 0,
			cutout: '70%',
			responsive: false,
			hover: {
				mode: null
			},
			plugins: {
				tooltip: {
					enabled: false
				},
				legend: {
					labels: {
						boxWidth: 12,
						padding: 5,
					},
					position: 'right',
				}
			},
		},
	} );
};
