<?php
/**
 * Registration view
 *
 * Show registration screen with registration form.
 *
 * @link https://getfuzion.io
 *
 * @package CF_Images
 * @subpackage CF_Images/App/Views
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace CF_Images\App\Views;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="ai-wrap">
	<div class="ai-header">
		<div class="container">
			<h1><?php esc_html_e( 'Fuzion AI', 'fuzion' ); ?></h1>
		</div>
	</div>

	<main class="container">
		<article>
			<hgroup>
				<h2><?php esc_html_e( 'Register', 'fuzion' ); ?></h2>
				<h3>
					<?php esc_html_e( 'Already have an account?', 'fuzion' ); ?>
					<a href="<?php echo esc_url( $this->get_url( 'login' ) ); ?>">
						<?php esc_html_e( 'Login', 'fuzion' ); ?>
					</a>
				</h3>
			</hgroup>

			<div class="notice notice-error" id="ai-ajax-notice">
				<p></p>
			</div>

			<form id="ai-register-form">
				<label for="name">
					<span class="screen-reader-text"><?php esc_html_e( 'Email address', 'fuzion' ); ?></span>
					<input type="text" id="name" name="name" placeholder="<?php esc_attr_e( 'Name', 'fuzion' ); ?>" required>
				</label>

				<label for="email">
					<span class="screen-reader-text"><?php esc_html_e( 'Email address', 'fuzion' ); ?></span>
					<input type="email" id="email" name="email" placeholder="<?php esc_attr_e( 'Email address', 'fuzion' ); ?>" required>
				</label>

				<label for="password">
					<span class="screen-reader-text"><?php esc_html_e( 'Password', 'fuzion' ); ?></span>
					<input type="password" id="password" name="password" placeholder="<?php esc_attr_e( 'Password', 'fuzion' ); ?>" required>
				</label>

				<label for="password_confirmation">
					<span class="screen-reader-text"><?php esc_html_e( 'Confirm password', 'fuzion' ); ?></span>
					<input type="password" id="password_confirmation" name="password_confirmation" placeholder="<?php esc_attr_e( 'Confirm password', 'fuzion' ); ?>" required>
				</label>

				<button type="submit" class="contrast" id="ai-register-btn">
					<?php esc_html_e( 'Register', 'fuzion' ); ?>
				</button>
			</form>
		</article>
	</main>
</div>
