<?php
/**
 * Product page fuzion ai metabox
 *
 * Show metabox in Product page.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Views
 * @author Fuzion AI
 * @since 1.3.0
 */

namespace Fuzion\App\Views;

if ( ! defined( 'WPINC' ) ) {
	die;
}

$product = wc_get_product( get_the_ID() );
?>

<div class="notice notice-error" id="ai-ajax-notice" hidden>
	<p></p>
</div>

<div class="input-group-wrapper">
	<p><?php esc_html_e( 'Generate product description, based on product title and selected attributes.', 'fuzion' ); ?></p>
	<p><?php esc_html_e( 'Note: this action will overwrite current product description.', 'fuzion' ); ?></p>
</div>

<div class="input-group-wrapper">
	<label><?php echo esc_html__( 'Maximum credits per request', 'fuzion' ); ?></label>
	<div class="input-group">
		<input type="range" min="1" max="2048" value="80" />
		<input id="credits" type="number" value="80" min="1" max="2048" />
	</div>
</div>

<div class="input-group-wrapper">
	<label><?php echo esc_html__( 'Creativity level', 'fuzion' ); ?></label>
	<div class="input-group">
		<input type="range" min="1" max="100" value="60" />
		<input id="temperature" type="number" value="60" min="1" max="100" />
	</div>
</div>

<?php if ( count( $product->get_attributes() ) ) : ?>
	<div class="input-group-wrapper">
		<label><?php echo esc_html__( 'Attributes', 'fuzion' ); ?></label>
		<div class="input-group attributes-group">
			<?php foreach ( $product->get_attributes( 'edit' ) as $attribute ) : ?>
			<label>
				<input type="checkbox" value="1" name="<?php echo esc_attr( sanitize_title( $attribute->get_name() ) ); ?>" />
				<?php echo esc_html( wc_attribute_label( $attribute->get_name() ) ); ?>
			</label>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>

<div class="submit-wrapper">
	<span class="spinner"></span>
	<button id="generate-content" type="button" class="button"><?php echo esc_html__( 'Generate', 'fuzion' ); ?></button>
</div>
