<?php
/**
 * Awaiting confirmation view
 *
 * Shown after user has registered, but has not yet confirmed the email.
 *
 * @link https://getfuzion.io
 *
 * @package CF_Images
 * @subpackage CF_Images/App/Views
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace CF_Images\App\Views;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="ai-wrap">
	<div class="ai-header">
		<div class="container">
			<h1><?php esc_html_e( 'Fuzion AI', 'fuzion' ); ?></h1>
		</div>
	</div>

	<main class="container">
		<article>
			<hgroup>
				<h2><?php esc_html_e( 'Registration successful', 'fuzion' ); ?></h2>
				<h3>
					<?php esc_html_e( 'Check your email to complete verification', 'fuzion' ); ?>
				</h3>
			</hgroup>

			<p><?php esc_html_e( 'Thank you for registering! We have sent you a confirmation email.', 'fuzion' ); ?></p>

			<p>
				<?php
				printf( /* translators: %1$s - opening <a> tag, %2$s - closing </a> tag */
					esc_html__( 'If you have already confirmed your email, please %1$slogin and generate an API key%2$s.', 'fuzion' ),
					'<a href="' . esc_url( $this->get_url( 'login' ) ) . '">',
					'</a>'
				);
				?>
			</p>
		</article>
	</main>
</div>
