<?php
/**
 * Update API key view
 *
 * Show form to input a new API key.
 *
 * @link https://getfuzion.io
 *
 * @package CF_Images
 * @subpackage CF_Images/App/Views
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace CF_Images\App\Views;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="ai-wrap">
	<div class="ai-header">
		<div class="container">
			<h1><?php esc_html_e( 'Fuzion AI', 'fuzion' ); ?></h1>
		</div>
	</div>

	<main class="container">
		<article>
			<hgroup>
				<h2><?php esc_html_e( 'API key', 'fuzion' ); ?></h2>
				<h3>
					<?php
					printf( /* translators: %1$s - opening <a> tag for API key, %2$s - opening <a> tag for login, %3$s - closing </a> tag */
						esc_html__( "Don't have an API key? %1\$sGenerate%3\$s a key in your account or %2\$slogin%3\$s and we'll automatically generate one for you.", 'fuzion' ),
						'<a href="' . esc_url( $this->get_url( 'site-login' ) ) . '" target="_blank">',
						'<a href="' . esc_url( $this->get_url( 'login' ) ) . '">',
						'</a>'
					);
					?>
				</h3>
			</hgroup>

			<div class="notice notice-error" id="ai-ajax-notice">
				<p></p>
			</div>

			<form id="ai-api-key-form">
				<label for="api-key">
					<span class="screen-reader-text"><?php esc_html_e( 'API key', 'fuzion' ); ?></span>
					<input type="text" id="api-key" name="api-key" placeholder="<?php esc_attr_e( 'API key', 'fuzion' ); ?>" required>
				</label>

				<button type="submit" class="contrast" id="ai-update-api-key-btn">
					<?php esc_html_e( 'Update', 'fuzion' ); ?>
				</button>
			</form>
		</article>
	</main>
</div>
