<?php
/**
 * Account view
 *
 * Show account page with information.
 *
 * @link https://getfuzion.io
 *
 * @package CF_Images
 * @subpackage CF_Images/App/Views
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace CF_Images\App\Views;

use Fuzion\App\Models\Credit;

if ( ! defined( 'WPINC' ) ) {
	die;
}

?>

<div class="ai-wrap">
	<div class="ai-header">
		<div class="container">
			<h1><?php esc_html_e( 'Fuzion AI', 'fuzion' ); ?></h1>
		</div>
	</div>

	<main class="container">
		<div class="notice notice-error" id="ai-ajax-notice">
			<p></p>
		</div>

		<article>
			<hgroup>
				<h2><?php esc_html_e( 'Account page', 'fuzion' ); ?></h2>
				<h3>
					<?php esc_html_e( 'Subscription status', 'fuzion' ); ?>
				</h3>
			</hgroup>

			<div class="notice notice-success ai-active-sub-notice">
				<p><?php esc_html_e( 'You have an active subscription', 'fuzion' ); ?></p>
			</div>

			<table role="grid">
				<tr>
					<td><strong><?php esc_html_e( 'Plan details', 'fuzion' ); ?></strong></td>
					<td>
						<span id="plan"><?php echo esc_html( Credit::get_plan_name() ); ?></span><br />
						<?php
						printf( /* translators: %d - number of words per month on selected plan */
							esc_html__( '- %s words per month', 'fuzion' ),
							'<span id="monthly-content">' . absint( Credit::get_monthly_credits() ) . '</span>'
						);
						?>
						<br />
						<?php
						printf( /* translators: %d - number of images per month on selected plan */
							esc_html__( '- %s images per month', 'fuzion' ),
							'<span id="monthly-images">' . absint( Credit::get_monthly_credits( 'images' ) ) . '</span>'
						);
						?>
						<br />
						<?php
						printf( /* translators: %d - number of seo queries per month on selected plan */
							esc_html__( '- %s SEO queries per month', 'fuzion' ),
							'<span id="monthly-seo">' . absint( Credit::get_monthly_credits( 'seo' ) ) . '</span>'
						);
						?>
					</td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e( 'Requests performed', 'fuzion' ); ?></strong></td>
					<td>
						<span id="requests"><?php echo absint( Credit::get_requests_count() ); ?></span>
					</td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e( 'Credits remaining', 'fuzion' ); ?></strong></td>
					<td>
						<span id="remaining-content">- <?php echo absint( Credit::get_available_credits() ); ?></span>
						<em data-tooltip="<?php esc_attr_e( '1 word is approximately 1.33 credits', 'fuzion' ); ?>">
							<?php esc_html_e( 'content credits', 'fuzion' ); ?>
						</em><br />
						<span id="remaining-images">- <?php echo absint( Credit::get_available_credits( 'images' ) ); ?></span>
						<?php esc_html_e( 'image credits', 'fuzion' ); ?><br />
						<span id="remaining-seo">- <?php echo absint( Credit::get_available_credits( 'seo' ) ); ?></span>
						<?php esc_html_e( 'SEO credits', 'fuzion' ); ?>
					</td>
				</tr>
			</table>

			<?php if ( 100 > Credit::get_available_credits() ) : ?>
				<p>
					<?php
					printf( /* translators: %1$s - opening <a> tag, %2$s - closing </a> tag */
						esc_html__( 'Looking for more credits? %1$sUpgrade%2$s to one of our paid plans.', 'fuzion' ),
						'<a href="' . esc_url( $this->get_url( 'site' ) ) . '" target="_blank">',
						'</a>'
					);
					?>
				</p>
			<?php endif; ?>

			<div class="ai-buttons">
				<a href="<?php echo esc_url( $this->get_url( 'api-key' ) ); ?>" class="outline" role="button">
					<?php esc_html_e( 'Update API key', 'fuzion' ); ?>
				</a>
				<a href="#" class="secondary outline" role="button" id="ai-ajax-logout">
					<?php esc_html_e( 'Log out', 'fuzion' ); ?>
				</a>
			</div>

			<p class="ai-stats-update">
				<?php esc_html_e( 'Incorrect stats?', 'fuzion' ); ?>
				<a href="#" id="ai-ajax-sync-stats">
					<?php esc_html_e( 'Sync subscription data', 'fuzion' ); ?>
				</a>
			</p>
		</article>
	</main>
</div>
