<?php
/**
 * The file that defines the helper traits
 *
 * Traits class that has a bunch of helper functions, used across the plugin to simplify most common tasks, like
 * getting the plugin slug or version.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Traits
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace Fuzion\App\Traits;

/**
 * Utils trait.
 *
 * @since 1.0.0
 */
trait Utils {

	/**
	 * Get plugin version.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_version(): string {
		return defined( 'FUZION_VERSION' ) ?? '1.0.0';
	}

	/**
	 * Get plugin slug.
	 *
	 * The slug should always match the text domain from the main plugin file.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public function get_slug(): string {
		return 'fuzion';
	}

	/**
	 * Get page URL
	 *
	 * @since 1.0.0
	 *
	 * @param string $page  Page type.
	 *
	 * @return string
	 */
	public function get_url( string $page = 'plugin' ): string {
		switch ( $page ) {
			case 'api-key':
				return admin_url( 'options-general.php' ) . '?page=' . $this->get_slug() . '&view=api-key';
			case 'login':
				return admin_url( 'options-general.php' ) . '?page=' . $this->get_slug() . '&view=login';
			case 'register':
				return 'https://getfuzion.io/register';
			case 'site':
				return 'https://getfuzion.io';
			case 'site-login':
				return 'https://getfuzion.io/login';
			case 'plugin':
			default:
				return admin_url( 'admin.php?page=' . $this->get_slug() );
		}
	}

}
