<?php
/**
 * The class that defines the SEO model
 *
 * Manage SEO data.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Models
 * @author Fuzion AI
 * @since 1.2.0
 */

namespace Fuzion\App\Models;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * SEO class.
 *
 * @since 1.2.0
 */
class SEO {

	/**
	 * Parse API response data and format it in a way that we can use in the plugin.
	 *
	 * @sicne 1.2.0
	 *
	 * @param array  $data     Data array.
	 * @param string $keyword  Keyword.
	 *
	 * @return array
	 */
	public static function parse_response( array $data, string $keyword ): array {

		$percent_searches_not_clicked = $data['percentSearchesNotClicked'] ?? -1;

		$percent_paid_clicks = $data['percentPaidClicks'] ?? -1;
		if ( $percent_paid_clicks > 1 ) {
			$percent_paid_clicks = 1;
		}
		$percent_paid_clicks = $percent_paid_clicks / 0.25;

		$data = array(
			'clickedAnyResult'            => is_finite( $percent_searches_not_clicked ) ? 1 - $percent_searches_not_clicked : -1,
			'percentDesktopSearches'      => $data['percentDesktopSearches'] ?? null,
			'percentMobileSearches'       => $data['percentMobileSearches'] ?? null,
			'percentPaidClicks'           => $data['percentPaidClicks'] ?? null,
			'percentPaidClicksChartValue' => $percent_paid_clicks > 0 ? min( 0.9875, $percent_paid_clicks ) : -1,
			'rankingDifficulty'           => $data['rankingDifficulty'] ?? null,
			'searchVolume'                => $data['searchVolume'] ?? null,
			'totalMonthlyClicks'          => $data['totalMonthlyClicks'] ?? null,
		);

		$key = self::get_cache_key( $keyword );
		set_transient( $key, $data, DAY_IN_SECONDS );

		return $data;

	}

	/**
	 * Get cache key.
	 *
	 * @param string $keyword  Keyword.
	 *
	 * @return string
	 */
	public static function get_cache_key( string $keyword ): string {
		return 'fuzion_keyword_' . strtolower( $keyword );
	}

}
