<?php
/**
 * The class that defines the Product model
 *
 * Get product related data: attributes, titles, etc.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Models
 * @author Fuzion AI
 * @since 1.3.0
 */

namespace Fuzion\App\Models;

use WC_Product;
use WC_Product_Attribute;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Product class.
 *
 * @since 1.3.0
 */
class Product {

	/**
	 * Generate a list of attributes with values that can be sumbitted to the API.
	 *
	 * @since 1.3.0
	 *
	 * @param WC_Product $product    WooCommerce product object.
	 * @param array      $attributes Selected product attributes.
	 *
	 * @return array
	 */
	public static function get_product_attributes( WC_Product $product, array $attributes ): array {

		$results = array();

		foreach ( $product->get_attributes() as $slug => $attribute ) {
			if ( ! in_array( $slug, $attributes, true ) ) {
				continue;
			}

			/**
			 * Product attributes.
			 *
			 * @var WC_Product_Attribute $attribute
			 */
			if ( $attribute->is_taxonomy() ) {
				$values = $attribute->get_terms();
				$values = wp_list_pluck( $values, 'name' );
			} else {
				$values = $attribute->get_options();
			}

			$results[ $slug ] = array(
				'name'   => wc_attribute_label( $attribute->get_name() ),
				'values' => $values,
			);
		}

		return $results;

	}

}
