<?php
/**
 * The class that defines the Image model
 *
 * Manage Image data.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Models
 * @author Fuzion AI
 * @since 1.3.0
 */

namespace Fuzion\App\Models;

use Exception;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Image class.
 *
 * @since 1.3.0
 */
class Image {

	/**
	 * Save image in media library.
	 *
	 * @since 1.3.0
	 *
	 * @param string $file     The URL of the image to download.
	 * @param int    $post_id  Optional. The post ID the media is to be associated with.
	 * @param string $desc     Optional. Description of the image.
	 *
	 * @return int
	 * @throws Exception Error from saving image in media library.
	 */
	public static function save_image( string $file, int $post_id = 0, string $desc = '' ): int {

		$result = media_sideload_image( $file, $post_id, $desc, 'id' );

		if ( is_wp_error( $result ) ) {
			throw new Exception( $result->get_error_message(), $result->get_error_code() );
		}

		return $result;

	}

}
