<?php
/**
 * The file that defines the plugin upgrade class
 *
 * Performs plugin updates and makes sure the settings are always up-to-date.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App
 * @author Fuzion AI
 * @since 1.2.0
 */

namespace Fuzion\App;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The update plugin class.
 *
 * @since 1.2.0
 */
class Update {

	/**
	 * Check if an upgrade is required.
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	public static function do_upgrade() {

		$version = get_site_option( 'fuzion-version' );

		if ( ! $version && version_compare( FUZION_VERSION, '1.2.0', '<' ) ) {
			self::upgrade_1_2_0();
		}

		if ( ! $version || FUZION_VERSION !== $version ) {
			update_site_option( 'fuzion-version', FUZION_VERSION );
		}

	}

	/**
	 * Upgrade to version 1.2.0.
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	private static function upgrade_1_2_0() {

		$credits = get_option( 'fuzion-credits' );

		if ( ! $credits || ! isset( $credits['content']['plan'] ) ) {
			return;
		}

		$credits['plan'] = $credits['content']['plan'];
		unset( $credits['content']['plan'] );

		update_option( 'fuzion-credits', $credits );

	}

}
