<?php
/**
 * The file that defines the editor plugin class
 *
 * Everything editor related - register and utilize the Plugin Sidebar API to add a sidebar to the editor.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace Fuzion\App;

use Fuzion\App\Models\User;

/**
 * Editor plugin class.
 *
 * @since 1.0.0
 */
class Editor {
	use Traits\Utils;

	/**
	 * Class constructor.
	 *
	 * Register all related class hooks.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		if ( ! User::has_api_token() ) {
			return;
		}

		add_action( 'init', array( $this, 'register_plugin_sidebar' ) );
		add_action( 'enqueue_block_editor_assets', array( $this, 'enqueue_assets' ) );

	}

	/**
	 * Register sidebar scripts.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_plugin_sidebar() {

		wp_register_style(
			$this->get_slug() . '-editor',
			FUZION_DIR_URL . 'assets/css/ai-editor.min.css',
			array(),
			$this->get_version()
		);

		wp_register_script(
			$this->get_slug() . '-editor',
			FUZION_DIR_URL . 'assets/js/ai-editor.min.js',
			array( 'wp-plugins', 'wp-edit-post', 'wp-element' ),
			$this->get_version(),
			true
		);

		wp_localize_script(
			$this->get_slug() . '-editor',
			'Fuzion',
			array(
				'nonce' => wp_create_nonce( 'fuzion-nonce' ),
				'links' => array(
					'updatedApiKey' => $this->get_url( 'api-key' ),
				),
			)
		);

	}

	/**
	 * Enqueue required assets.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function enqueue_assets() {
		wp_enqueue_script( $this->get_slug() . '-editor' );
		wp_enqueue_style( $this->get_slug() . '-editor' );
	}

}
