<?php
/**
 * Product Description AI API class
 *
 * This class defines all code for performing API queries to the product description API.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Api/WooCommerce
 * @author Fuzion AI
 * @since 1.3.0
 */

namespace Fuzion\App\Api\WooCommerce;

use Exception;
use Fuzion\App\Api\Request;
use stdClass;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Product class
 *
 * @since 1.3.0
 */
class Product extends Request {

	/**
	 * Perform API query.
	 *
	 * @since 1.3.0
	 *
	 * @param array $params  Query parameters.
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function query( array $params ): stdClass {

		$this->set_method( 'POST' );
		$this->set_endpoint( 'product/description' );

		$response = $this->request( $params );
		return $this->process_response( $response );

	}

}
