<?php
/**
 * SEO API class
 *
 * This class defines all code for performing API queries to the SEO API.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Api
 * @author Fuzion AI
 * @since 1.2.0
 */

namespace Fuzion\App\Api;

use Exception;
use stdClass;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * SEO class
 *
 * @since 1.2.0
 */
class SEO extends Request {

	/**
	 * Perform API query.
	 *
	 * @since 1.2.0
	 *
	 * @param array $params  Query parameters.
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function query( array $params ): stdClass {

		$this->set_method( 'POST' );
		$this->set_endpoint( 'keywords' );

		$response = $this->request( $params );
		$response = $this->process_response( $response );

		return $response->data->results[0];

	}

}
