<?php
/**
 * Content AI API class
 *
 * This class defines all code for performing API queries to the content API.
 *
 * @link https://getfuzion.io
 *
 * @package Fuzion
 * @subpackage Fuzion/App/Api
 * @author Fuzion AI
 * @since 1.0.0
 */

namespace Fuzion\App\Api;

use Exception;
use stdClass;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Content class
 *
 * @since 1.0.0
 */
class Content extends Request {

	/**
	 * Perform API query.
	 *
	 * @since 1.0.0
	 *
	 * @param array $params  Query parameters.
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function query( array $params ): stdClass {

		$this->set_method( 'POST' );
		$this->set_endpoint( 'content' );

		$response = $this->request( $params );
		return $this->process_response( $response );

	}

	/**
	 * Fetch API and plan stats.
	 *
	 * @since 1.0.0
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function sync_stats(): stdClass {

		$this->set_method( 'GET' );
		$this->set_endpoint( 'stats' );

		$response = $this->request();
		return $this->process_response( $response );

	}

	/**
	 * Perform API query to generate an image.
	 *
	 * @since 1.3.0
	 *
	 * @param array $params  Query parameters.
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function generate_image( array $params ): stdClass {

		$this->set_method( 'POST' );
		$this->set_timeout( 60 );
		$this->set_endpoint( 'images/generate' );

		$response = $this->request( $params );
		return $this->process_response( $response );

	}

	/**
	 * Perform API query to generate code.
	 *
	 * @since 1.4.0
	 *
	 * @param array  $params  Query parameters.
	 * @param string $type    Type of query. Accepts: code_edit, code_generate.
	 *
	 * @return stdClass
	 * @throws Exception API call exception.
	 */
	public function generate_code( array $params, string $type ): stdClass {

		$this->set_method( 'POST' );

		if ( 'code_edit' === $type ) {
			$this->set_endpoint( 'code/edit' );
		} else {
			$this->set_endpoint( 'code/generate' );
		}

		$response = $this->request( $params );
		return $this->process_response( $response );

	}

}
