<?php

namespace FrontisInteraction;

defined('ABSPATH') || exit;

class Plugin
{
	/**
	 * Plugin version
	 *
	 * @var string
	 */
	const VERSION = '1.0.0';

	/**
	 * Plugin slug
	 *
	 * @var string
	 */
	const SLUG = 'frontis-interaction';

	/**
	 * Plugin prefix
	 *
	 * @var string
	 */
	const PREFIX = 'fb_';

	/**
	 * Plugin text domain
	 *
	 * @var string
	 */
	const TEXT_DOMAIN = 'frontis-interaction';

	/**
	 * Admin instance
	 *
	 * @var Admin
	 */
	public $admin;

	/**
	 * Asset instance
	 *
	 * @var Asset
	 */
	public $asset;

	/**
	 * Plugin settings
	 *
	 * @var array|null
	 */
	public static $settings = null;

	/**
	 * Loaded blocks
	 *
	 * @var array
	 */
	public static $blocks = [];

	/**
	 * Plugin instance
	 *
	 * @var Plugin|null
	 */
	private static $instance = null;

	/**
	 * Constructor
	 */
	private function __construct()
	{
		$this->define_constants();
		$this->set_locale();
		$this->init_classes();
		$this->init_hooks();

		add_action('enqueue_block_editor_assets', [$this, 'enqueue_editor_assets'], 100);
		add_action('admin_init', [$this, 'handle_activation_redirect']);
		add_action('wp_enqueue_scripts', [$this, 'enqeue_scripts']);
		add_action('init', [$this, 'register_animation_meta']);
	}

	public function enqueue_editor_assets()
	{
		$is_dev = defined('WP_ENV') && WP_ENV === 'development';

		$asset_path = FRONTIS_PLUGIN_DIR . '../build/index.asset.php';
		$js_dependencies = [];
		$version = false;
		if (file_exists($asset_path)) {
			$asset_file = include $asset_path;

			$js_dependencies = $asset_file['dependencies'];
			$version = $asset_file['version'];
		}

		if ($is_dev) {
			wp_enqueue_script(
				'frontis-interaction-runtime',
				FRONTIS_PLUGIN_URL . '../build/runtime.js',
				array(),
				FRONTIS_PLUGIN_VERSION,
				true
			);
			wp_enqueue_script(
				'frontis-interaction',
				FRONTIS_PLUGIN_URL . '../build/index.js',
				$js_dependencies,
				$version,
				true
			);
			wp_enqueue_style('frontis', FRONTIS_PLUGIN_URL . '../build/index.css', [], $version);
		} else {
			wp_enqueue_script(
				'frontis-interaction',
				FRONTIS_PLUGIN_URL . '../build/index.js',
				$js_dependencies,
				$version,
				true
			);

			wp_enqueue_style('frontis', FRONTIS_PLUGIN_URL . '../build/index.css', [], $version);
		}
	}


	public function enqeue_scripts()
	{
		wp_register_script('motion', FRONTIS_PLUGIN_URL . '../assets/js/motion.js', [], '1.0.0', true);
	}


	public function register_animation_meta()
	{
		$post_types = get_post_types(array('show_in_rest' => true), 'names');

		foreach ($post_types as $post_type) {
			register_post_meta($post_type, '_frontisInteractions', array(
				'type'         => 'string',
				'single'       => true,
				'show_in_rest' => true,
				'auth_callback' => function () {
					return current_user_can('edit_posts');
				},
			));
		}
	}


	/**
	 * Get plugin instance
	 *
	 * @return Plugin
	 */
	public static function get_instance()
	{
		if (null === self::$instance) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Define constants
	 */
	private function define_constants()
	{
		// Generate plugin Constants
		define('FRONTIS_PLUGIN_NAME', 'Frontis Interaction');
		define('FRONTIS_PLUGIN_VERSION', self::VERSION);
		define('FRONTIS_PLUGIN_AUTHOR', 'Frontis');

		// Directory Paths
		define('FRONTIS_PLUGIN_DIR', plugin_dir_path(__FILE__));
		define('FRONTIS_PLUGIN_URL', plugin_dir_url(__FILE__));
	}

	/**
	 * Set locale
	 */
	private function set_locale()
	{
		// add_action('plugins_loaded', function () {
		// 	load_plugin_textdomain(self::TEXT_DOMAIN, false, dirname(plugin_basename(FB_PLUGIN_FILE)) . '/languages');
		// });
	}

	/**
	 * Initialize classes
	 */
	private function init_classes()
	{
		AnimationBuilder::get_instance();
	}

	/**
	 * Initialize hooks
	 */
	private function init_hooks()
	{
		add_action('plugins_loaded', [$this, 'init_plugin']);
	}

	/**
	 * Initialize plugin
	 */
	public function init_plugin() {}

	/**
	 * Set flag to trigger redirect on activation
	 */
	public function set_activation_redirect()
	{
		add_option('frontis_interaction_do_activation_redirect', true);
	}

	/**
	 * Handle redirect to agreement page after activation
	 */
	public function handle_activation_redirect()
	{
		if (
			get_option('frontis_interaction_do_activation_redirect', false)
			&& current_user_can('manage_options')
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended
			&& !isset($_GET['activate-multi'])
		) {
			delete_option('frontis_interaction_do_activation_redirect');
		}
	}
}
