<?php

namespace FrontisInteraction\Models\Triggers;

use FrontisInteraction\Models\Target;

defined('ABSPATH') || exit;


/**
 * Abstract class for all target based triggers.
 * Target based triggers are events that are triggered based on a target element, such as ClickTrigger, HoverTrigger, etc.
 *
 * This class is the base class for all target based triggers, which provides a basic structure for triggers.
 * @package FrontisInteraction.Models\Triggers
 * @since 1.1.0
 **/
abstract class TargetBasedTrigger extends Trigger
{
    /**
     * The target element that the trigger event is attached to.
     *
     * @var Target
     * @since 1.1.0
     */
    protected Target $target;


    /**
     * Constructor.
     *
     * Creates a new TargetBasedTrigger object with the given data.
     *
     * The associative array should contain the following keys:
     *   - target: Associative array of target element data.
     *
     * @param array $data Associative array of data.
     * @since 1.1.0
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);

        $this->target = new Target($data['target'] ?? []);
    }


    /**
     * Gets the target element of the trigger event.
     *
     * @return Target The target element of the trigger event.
     * @since 1.1.0
     */
    public function getTarget(): Target
    {
        return $this->target;
    }
}
