<?php

namespace FrontisInteraction\Models\Triggers;

use FrontisInteraction\Models\Options\LoadOptions;

defined('ABSPATH') || exit;


/**
 * Class representing a load trigger event.
 *
 * This class handles the user load event  data.
 *
 * @package FrontisInteraction\Models\Triggers
 * @since 1.1.0
 */
class LoadTrigger extends TargetBasedTrigger
{
    /**
     * Load trigger options.
     *
     * @var LoadOptions
     * @since 1.1.0
     */
    private LoadOptions $options;


    /**
     * Constructor.
     *
     * Creates a new LoadTrigger object with the given data.
     *
     * The associative array should contain the following keys:
     *   - options: Associative array of options for the load trigger event.
     *
     * @param array $data Associative array of data.
     * @since 1.1.0
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->options = new LoadOptions($data['options'] ?? []);
    }


    /**
     * Returns the options for the load trigger event.
     *
     * @return LoadOptions The options for the load trigger event.
     * @since 1.1.0
     */
    public function getOptions(): LoadOptions
    {
        return $this->options;
    }
}
