<?php

namespace FrontisInteraction\Models\Triggers;

use FrontisInteraction\Models\Options\InViewOptions;

defined('ABSPATH') || exit;

/**
 * Class representing a click trigger event.
 *
 * This class handles the user click event options data.
 *
 * @package FrontisInteraction\Models\Triggers
 * @since 2.0.2
 */
class InViewTrigger extends TargetBasedTrigger
{

    /**
     * Options for the click trigger event.
     *
     * @var InViewOptions
     * @since 1.1.0
     */
    private InViewOptions $options;


    /**
     * Constructor.
     *
     * Creates a new ClickTrigger object with the given data.
     *
     * The associative array should contain the following keys:
     *   - options: Associative array of options for the click trigger event.
     *
     * @param array $data Associative array of data.
     * @since 1.1.0
     * */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->options = new InViewOptions($data['options'] ?? []);
    }


    /**
     * Returns the options for the click trigger event.
     *
     * @return InViewOptions The options for the click trigger event.
     * @since 1.1.0
     */
    public function getOptions(): InViewOptions
    {
        return $this->options;
    }
}
