<?php

namespace FrontisInteraction\Models\Triggers;

use FrontisInteraction\Models\Options\HoverOptions;

defined('ABSPATH') || exit;

/**
 * Class representing a hover trigger event.
 *
 * This class handles the user hover event options data.
 *
 * @package FrontisInteraction\Models\Triggers
 * @since 1.1.0
 */
class HoverTrigger extends TargetBasedTrigger
{

    /**
     * The options for the hover trigger event.
     * 
     * @var HoverOptions
     * @since 1.1.0
     */
    private HoverOptions $options;



    /**
     * Constructor.
     *
     * Creates a new HoverTrigger object with the given data.
     *
     * The associative array should contain the following keys:
     *   - options: Associative array of options for the hover trigger event.
     *
     * @param array $data Associative array of data.
     * @since 1.1.0
     */
    public function __construct(array $data = [])
    {
        parent::__construct($data);
        $this->options = new HoverOptions($data['options'] ?? []);
    }



    /**
     * Returns the options for the hover trigger event.
     *
     * @return HoverOptions The options for the hover trigger event.
     * @since 1.1.0
     * */
    public function getOptions(): HoverOptions
    {
        return $this->options;
    }
}
