<?php

namespace FrontisInteraction\Models\Triggers;

defined('ABSPATH') || exit;

/**
 * Class representing a fallback trigger event.
 *
 * This class handles the user fallback event options data.
 *
 * @package FrontisInteraction\Models\Triggers
 * @since 1.1.0
 **/
class FallbackTrigger extends Trigger
{

    /**
     * Constructor for FallbackTrigger.
     *
     * Creates a new FallbackTrigger object with the given data.
     *
     * @param array $data The data for the FallbackTrigger.
     * @since 1.1.0
     **/
    public function __construct(array $data = [])
    {
        parent::__construct($data);
    }

    /**
     * Returns the action of the trigger.
     *
     * If the action is not set, it will return 'play'.
     *
     * @return string The action of the trigger.
     * @since 1.1.0
     **/
    public function getAction(): string
    {
        return parent::getAction() ?: 'play';
    }
}
