<?php

namespace FrontisInteraction\Models\Sequence\Property;

defined('ABSPATH') || exit;

/**
 * Class representing a color property.
 * 
 * @package FrontisInteraction\Models\Sequence\Property
 * @since 1.1.0
 */
class ColorProperty implements BaseProperty
{
    /**
     * @var mixed
     */
    private $value;

    /**
     * @param mixed $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * TODO: Implement sanitize() for ColorProperty
     */
    public function getValue(): string
    {
        if (is_string($this->value))
            return $this->value;
        return '';
    }
}
