<?php

namespace FrontisInteraction\Models\Options;

defined('ABSPATH') || exit;

/**
 * Abstract class for all trigger options.
 *
 * This class is the base class for all trigger options, such as ClickOptions, HoverOptions, etc.
 *
 * It provides a basic structure for trigger options, with a single property for the timeline action to perform on trigger.
 *
 * @package FrontisInteraction\Models\Options
 * @since 1.1.0
 */
abstract class TriggerOptions
{
    /**
     * Constructor.
     *
     * Creates a new TriggerOptions object with the given action.
     *
     * @param array $options Associative array of options.
     * @since 1.1.0
     */
    public function __construct(array $options) {}
}
