<?php

namespace FrontisInteraction\Models\Factories;

use FrontisInteraction\Models\Triggers\ClickTrigger;
use FrontisInteraction\Models\Triggers\FallbackTrigger;
use FrontisInteraction\Models\Triggers\HoverTrigger;
use FrontisInteraction\Models\Triggers\InViewTrigger;
use FrontisInteraction\Models\Triggers\LoadTrigger;
use FrontisInteraction\Models\Triggers\TriggerInterface;

defined('ABSPATH') || exit;

class TriggerFactory
{
    public static function create(array $data): TriggerInterface
    {

        $type = trim((string) ($data['type'] ?? ''));

        switch ($type) {
            case 'click':
                return new ClickTrigger($data);
            case 'hover':
                return new HoverTrigger($data);
            case 'load':
                return new LoadTrigger($data);
            case 'inView':
                return new InViewTrigger($data);
            default:
                return new FallbackTrigger($data);
        }
    }
}
