<?php

namespace FrontisInteraction\Generator\Triggers;

use FrontisInteraction\Models\Triggers\InViewTrigger;

class InViewEventGenerator implements TriggerEventGenerator
{
    private InViewTrigger $trigger;
    private string $animationVar;
    private \Closure $innerAnimationCB;

    /**
     * Constructs a ClickEventGenerator object.
     *
     * @param InViewTrigger $trigger The trigger object to generate code for.
     * @param string $animationVar The variable name of the animation timeline.
     * @param \Closure $innerAnimationCB An optional array of timeline animation lines.
     */
    public function __construct(InViewTrigger $trigger, string $animationVar, \Closure $innerAnimationCB)
    {
        $this->trigger = $trigger;
        $this->animationVar = $animationVar;
        $this->innerAnimationCB = $innerAnimationCB;
    }


    /**
     * Generate JavaScript code to attach a animation timeline trigger to DOM elements.
     *
     * This function outputs an array of JS code lines that:
     *   - Select elements by a CSS selector
     *   - Attach an event listener
     *   - Execute a animation timeline action and optional animations
     *
     * @return array Array of JavaScript code lines.
     */
    public function generate(): array
    {
        $lines = [];
        $selector = $this->trigger->getTarget()->getSelector();
        $action = $this->trigger->getAction();

        $lines[] = "Motion.inView($selector, function(el) {";
        $lines[] = "\t{$this->animationVar}.{$action}();";

        $lines[] = "});";

        return $lines;
    }
}
