<?php

namespace FrontisInteraction\Generator\Triggers;

use FrontisInteraction\Models\Triggers\Trigger;

defined('ABSPATH') || exit;


/**
 * Class to generate JavaScript code for a animation timeline trigger from a given FallbackTrigger object.
 *
 * This class handles the user fallback event options data.
 *
 * @package FrontisInteractionPro\Generator\Triggers
 */
class FallbackTriggerGenerator implements TriggerEventGenerator
{
    /**
     * The Trigger object to generate code for.
     *
     * @var Trigger
     */
    private Trigger $trigger;

    /**
     * The animation timeline variable to use in the generated code.
     *
     * @var string
     */
    private string $animationVar;

    /**
     * A callback function for generating triggered animation code.
     * 
     * @var \Closure
     */
    private \Closure $innerAnimationCB;


    /**
     * Constructs a FallbackTriggerGenerator object.
     *
     * Initializes the class with the given Trigger object, animation timeline variable, and a callback for generating triggered animation code.
     *
     * @param Trigger $trigger The Trigger object to generate code for.
     * @param string $animationVar The animation timeline variable to use in the generated code.
     * @param \Closure $innerAnimationCB A callback function for generating triggered animation code.
     * @since 1.1.0
     */
    public function __construct(Trigger $trigger, string $animationVar, \Closure $innerAnimationCB)
    {
        $this->trigger = $trigger;
        $this->animationVar = $animationVar;
        $this->innerAnimationCB = $innerAnimationCB;
    }




    /**
     * Generates an array of code lines for a given FallbackTrigger object.
     *
     * The generated code will execute the given action on the given animation timeline variable.
     *
     * @return array The generated code lines.
     * @since 1.1.0
     */
    public function generate(): array
    {
        $lines = [];
        $action = $this->trigger->getAction();

        $lines[] = "{$this->animationVar}.{$action}();";
        return $lines;
    }
}
