<?php

namespace FrontisInteraction\Generator\Factories;

use FrontisInteraction\Generator\Triggers\ClickEventGenerator;
use FrontisInteraction\Generator\Triggers\FallbackTriggerGenerator;
use FrontisInteraction\Generator\Triggers\HoverEventGenerator;
use FrontisInteraction\Generator\Triggers\InViewEventGenerator;
use FrontisInteraction\Generator\Triggers\LoadEventGenerator;
use FrontisInteraction\Generator\Triggers\TriggerEventGenerator;
use FrontisInteraction\Models\Triggers\ClickTrigger;
use FrontisInteraction\Models\Triggers\HoverTrigger;
use FrontisInteraction\Models\Triggers\InViewTrigger;
use FrontisInteraction\Models\Triggers\LoadTrigger;
use FrontisInteraction\Models\Triggers\TriggerInterface;

class TriggerGenerator
{
    /**
     * @param TriggerInterface $trigger
     * @param string $animationVar
     * @param \Closure $innerAnimationCB
     * @return TriggerEventGenerator
     */
    public static function create(TriggerInterface $trigger, string $animationVar, \Closure $innerAnimationCB): TriggerEventGenerator
    {

        if ($trigger instanceof ClickTrigger) {
            return new ClickEventGenerator($trigger, $animationVar, $innerAnimationCB);
        }

        if ($trigger instanceof HoverTrigger) {
            return new HoverEventGenerator($trigger, $animationVar, $innerAnimationCB);
        }

        if ($trigger instanceof LoadTrigger) {
            return new LoadEventGenerator($trigger, $animationVar, $innerAnimationCB);
        }

        if($trigger instanceof InViewTrigger) {
            return new InViewEventGenerator($trigger, $animationVar, $innerAnimationCB);
        }

        return new FallbackTriggerGenerator($trigger, $animationVar, $innerAnimationCB);
    }
}
