wp.domReady(() => {
    if (!wp || !wp.data || !wp.element) return;

    const BUTTON_ID = 'frontis-open-sidebar-btn';
    const WRAPPER_ID = 'frontis-sidebar-btn-wrapper';
    const SIDEBAR_NAME = 'frontis-interactions'; // Must match your PluginSidebar name

    const openFrontisSidebar = () => {
        // wp.data.dispatch('core/edit-post').togglePinnedPluginItem('frontis-interactions:frontis-interactions');
        document.querySelector('[aria-controls="frontis-interactions:frontis-interactions"]').click();
    };

    const createButton = () => {
        const wrapper = document.createElement('div');
        wrapper.id = WRAPPER_ID;
        wrapper.style.display = 'flex';
        wrapper.style.alignItems = 'center';
        wrapper.style.marginLeft = '8px';

        const button = document.createElement('button');
        button.id = BUTTON_ID;
        button.className = 'components-button is-secondary';
        button.textContent = 'Frontis Interactions';
        button.type = 'button';
        button.addEventListener('click', openFrontisSidebar);

        wrapper.appendChild(button);
        return wrapper;
    };

    const injectButton = () => {
        const toolbar = document.querySelector('.edit-post-header-toolbar, .edit-site-header');
        if (!toolbar) return;

        const existing = toolbar.querySelector(`#${WRAPPER_ID}`);
        if (existing) existing.remove();

        toolbar.appendChild(createButton());
    };

    // Inject after editor fully loads
    wp.domReady(() => {
        injectButton();
    });

    // Optional: observe toolbar changes
    const observer = new MutationObserver(() => {
        const toolbar = document.querySelector('.edit-post-header-toolbar, .edit-site-header');
        if (toolbar && !toolbar.querySelector(`#${BUTTON_ID}`)) {
            injectButton();
        }
    });

    observer.observe(document.body, { childList: true, subtree: true });

    window.addEventListener('beforeunload', () => observer.disconnect());


});