<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class LR_Ajax_Login_Register_Shortcode
{

    public function __construct()
    {
        add_shortcode('AJAX-LOGIN_REGISTER', array($this, 'falr_login_register_shortcode'));
    }
    public function falr_login_register_shortcode($atts)
    {
        ob_start();
        $bg_custom_color = get_option('bg_custom_color', '#E25C4C');
        $text_custom_color = get_option('text_custom_color', '#FFFFFF');
        $bo_custom_color = get_option('bo_custom_color', '#B34336');
        $link_custom_color = get_option('link_custom_color', '#E25C4C');
        $pop_custom_color = get_option('pop_custom_color', '#FFFFFF');
        $label_custom_color = get_option('label_custom_color', '#878787');
        $add_telephone_number = get_option('add_telephone_number');
        $redirect_after_logout = get_option('redirect_after_logout');
?>
        <style type="text/css">
            .ajax-auth input.submit_button {
                background-color: <?php echo esc_attr($bg_custom_color); ?>;
                color: <?php echo esc_attr($text_custom_color); ?>;
                border-color: <?php echo esc_attr($bo_custom_color); ?>;
            }

            .ajax-auth a.close {
                background-color: <?php echo esc_attr($bg_custom_color); ?>;
                color: <?php echo esc_attr($text_custom_color); ?>;
                opacity: 0.99;
            }

            .ajax-auth h3 a,
            .ajax-auth a.text-link {
                color: <?php echo esc_attr($link_custom_color); ?>;
                font-weight: 600;
            }

            .ajax-auth h3 {
                color: #000000;
                font-weight: 600;
            }

            .ajax-auth h1 {
                color: #000000;
                font-weight: 600;
            }

            form.ajax-auth {
                color: <?php echo esc_attr($label_custom_color); ?>;
                background-color: <?php echo esc_attr($pop_custom_color); ?>;
            }
        </style>
        <?php
        if (!empty($redirect_after_logout)) {
            $logout_url =  esc_url(wp_logout_url(get_permalink($redirect_after_logout)));
        } else {
            $logout_url =  esc_url(wp_logout_url(home_url()));
        }
        if (is_user_logged_in()) {
            echo '<a href="' . $logout_url . '">' . __('Logout', 'frontend-ajax-login-register') . '</a>';
        } else {
            get_template_part('ajax', 'auth');
        ?>
            <a class="login_button" id="show_login" href="javascript:void(0);"><?php _e('Login', 'frontend-ajax-login-register'); ?></a>
            <a class="login_button" id="show_signup" href="javascript:void(0);"><?php _e('Signup', 'frontend-ajax-login-register'); ?></a>

            <form id="login" class="ajax-auth" action="login" method="post">
                <h3><?php _e('New to site?', 'frontend-ajax-login-register'); ?> <a id="pop_signup" href="javascript:void(0);"><?php _e('Create an Account', 'frontend-ajax-login-register'); ?></a></h3>
                <hr />
                <h1><?php _e('Login', 'frontend-ajax-login-register'); ?></h1>
                <p class="status"></p>
                <?php wp_nonce_field('ajax-login-nonce', 'security'); ?>
                <label for="username"><?php _e('Username', 'frontend-ajax-login-register'); ?></label>
                <input id="username" type="text" class="required" name="username">
                <label for="password"><?php _e('Password', 'frontend-ajax-login-register'); ?></label>
                <input id="password" type="password" class="required" name="password">
                <a id="pop_forgot" class="text-link" href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php _e('Lost password?', 'frontend-ajax-login-register'); ?></a>
                <input class="submit_button" type="submit" value="<?php esc_attr_e('Login', 'frontend-ajax-login-register'); ?>">
                <a class="close" href="javascript:void(0);">&times;</a>
            </form>

            <form id="register" class="ajax-auth" action="register" method="post">
                <h3><?php _e('Already have an account?', 'frontend-ajax-login-register'); ?> <a id="pop_login" href="javascript:void(0);"><?php _e('Login', 'frontend-ajax-login-register'); ?></a></h3>
                <hr />
                <h1><?php _e('Signup', 'frontend-ajax-login-register'); ?></h1>
                <p class="status"></p>
                <?php wp_nonce_field('ajax-register-nonce', 'signonsecurity'); ?>
                <label for="signonname"><?php _e('Username', 'frontend-ajax-login-register'); ?></label>
                <input id="signonname" type="text" name="signonname" class="required">
                <label for="email"><?php _e('Email', 'frontend-ajax-login-register'); ?></label>
                <input id="email" type="email" class="required email" name="email">
                <?php if (!empty($add_telephone_number)): ?>
                    <!----Start Telephone No---->
                    <label for="teleno"><?php _e('Contact No', 'frontend-ajax-login-register'); ?></label>
                    <input id="teleno" type="number" class="required teleno" name="teleno" minlength=10>
                    <!----End Telephone No---->
                <?php endif; ?>
                <label for="signonpassword"><?php _e('Password', 'frontend-ajax-login-register'); ?></label>
                <input id="signonpassword" type="password" class="required" name="signonpassword">
                <label for="password2"><?php _e('Confirm Password', 'frontend-ajax-login-register'); ?></label>
                <input type="password" id="password2" class="required" name="password2">
                <input class="submit_button" type="submit" value="<?php esc_attr_e('Signup', 'frontend-ajax-login-register'); ?>">
                <a class="close" href="javascript:void(0);">&times;</a>
            </form>

            <form id="forgot_password" class="ajax-auth" action="forgot_password" method="post">
                <h1><?php _e('Forgot Password', 'frontend-ajax-login-register'); ?></h1>
                <p class="status"></p>
                <?php wp_nonce_field('ajax-forgot-nonce', 'forgotsecurity'); ?>
                <label for="user_login"><?php _e('Username or E-mail', 'frontend-ajax-login-register'); ?></label>
                <input id="user_login" type="text" class="required" name="user_login">
                <input class="submit_button" type="submit" value="<?php esc_attr_e('Submit', 'frontend-ajax-login-register'); ?>">
                <a class="close" href="javascript:void(0);">&times;</a>
            </form>
<?php
        }
        return ob_get_clean();
    }
}
new LR_Ajax_Login_Register_Shortcode();
