<?php
class falr_Settings_Page
{
    public function __construct()
    {
        add_action('admin_menu', array($this, 'falr_create_settings'));
        add_action('admin_init', array($this, 'falr_setup_sections'));
        add_action('admin_init', array($this, 'falr_setup_fields'));
        add_action('admin_notices', array($this, 'falr_custom_admin_notice'));
        add_action('admin_enqueue_scripts', array($this, 'falr_enqueue_color_picker'));
        add_action('admin_init', array($this, 'reset_options_page'));
    }

    public function falr_create_settings()
    {
        $page_title = 'Frontend Ajax Login & Register Settings';
        $menu_title = 'Frontend Ajax Login & Register Settings';
        $capability = 'manage_options';
        $slug = 'frontendajaxloginre';
        $callback = array($this, 'falr_settings_content');
        add_options_page($page_title, $menu_title, $capability, $slug, $callback);
        add_options_page(null, null, $capability, $slug, array($this, 'reset_options_page'));
    }

    public function falr_enqueue_color_picker($hook_suffix)
    {
        // Only load on the specific settings page
        if ('settings_page_frontendajaxloginre' !== $hook_suffix) {
            return;
        }

        // Enqueue the color picker style and script
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');

        // Register and enqueue your custom script that will initialize the color picker
        wp_register_script('falr-color-picker-script', LR_DIR_URL . 'admin/js/falr-color-picker.js', array('jquery', 'wp-color-picker'), '1.0.0', true);
        wp_enqueue_script('falr-color-picker-script');

        wp_register_style('falr-custom-admin-css', LR_DIR_URL . 'admin/css/falr-custom-admin.css');
        wp_enqueue_style('falr-custom-admin-css');
    }


    public function falr_custom_admin_notice()
    {
        if (isset($_GET['success']) && $_GET['success'] == 'reset'):
?>
            <div class="notice notice-success is-dismissible">
                <p><?php _e('Reset all settings!', 'frontend-ajax-login-register'); ?></p>
            </div>
        <?php endif;
    }

    public function reset_options_page()
    {
        if (isset($_POST['reset'])) {
            $default_colors = array(
                'bg_custom_color' => '#E25C4C',
                'text_custom_color' => '#FFFFFF',
                'bo_custom_color' => '#B34336',
                'link_custom_color' => '#E25C4C',
                'pop_custom_color' => '#FFFFFF',
                'label_custom_color' => '#878787',
                'add_telephone_number' => ''
            );

            foreach ($default_colors as $key => $value) {
                update_option($key, $value);
            }

            wp_redirect(admin_url('options-general.php?page=frontendajaxloginre&success=reset'));
            exit;
        }
    }

    public function falr_settings_content()
    {
        ?>
        <div class="wrap">
            <h1>
                <?php esc_html_e('Frontend Ajax Login & Register Settings', 'frontend-ajax-login-register'); ?>
            </h1>
            <form method="POST" action="options.php">
                <?php
                settings_fields('frontendajaxloginre');
                do_settings_sections('frontendajaxloginre');
                submit_button();
                ?>
            </form>
            <form method="post" action="" class="reset-form" style="margin-top: -78px;margin-left: 110px;">
                <p class="submit">
                    <input name="reset" class="button button-secondary" type="submit" value="<?php _e('Reset all settings', 'frontend-ajax-login-register'); ?>" />
                    <input type="hidden" name="action" value="<?php _e('reset', 'frontend-ajax-login-register'); ?>" />
                </p>
            </form>
        </div>
<?php
    }

    public function falr_setup_sections()
    {
        add_settings_section('frontendajaxloginre_section', 'Shortcode: [AJAX-LOGIN_REGISTER]', array(), 'frontendajaxloginre');
    }

    public function falr_setup_fields()
    {
        $fields = array(
            array(
                'label' => 'Button Background Color',
                'id' => 'bg_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter button background color hex code.',
            ),
            array(
                'label' => 'Button Text Color',
                'id' => 'text_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter button text color hex code.',
            ),
            array(
                'label' => 'Button Border Color',
                'id' => 'bo_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter button border color hex code.',
            ),
            array(
                'label' => 'Link Color',
                'id' => 'link_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter link color hex code.',
            ),
            array(
                'label' => 'Popup Background Color',
                'id' => 'pop_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter popup background color hex code.',
            ),
            array(
                'label' => 'Form Label Color',
                'id' => 'label_custom_color',
                'type' => 'text',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Enter form label color hex code.',
            ),
            array(
                'label' => 'In Register form add Telephone Number ?',
                'id' => 'add_telephone_number',
                'type' => 'checkbox',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Check to add a telephone number field in the register form.',
            ),
            array(
                'label' => 'Select Page/Post For Redirect After Login',
                'id' => 'redirect_after_login',
                'type' => 'select',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Select Page/Post For Redirect After Login',
            ),
            // New field for redirect after logout
            array(
                'label' => 'Select Page/Post For Redirect After Logout',
                'id' => 'redirect_after_logout',
                'type' => 'select',
                'section' => 'frontendajaxloginre_section',
                'desc' => 'Select Page/Post For Redirect After Logout',
            ),
        );

        foreach ($fields as $field) {
            add_settings_field(
                $field['id'],
                $field['label'],
                array($this, 'falr_field_callback'),
                'frontendajaxloginre',
                $field['section'],
                $field
            );
            register_setting('frontendajaxloginre', $field['id']);
        }
    }

    public function falr_field_callback($field)
    {
        $value = get_option($field['id'], ''); // Get the saved value or default to ''

        switch ($field['type']) {
            case 'checkbox':
                $checked = checked(1, $value, false);
                echo sprintf(
                    '<label class="switch">
                <input name="%1$s" id="%1$s" type="checkbox" value="1" %2$s />
                <span class="slider round"></span>
            </label>',
                    esc_attr($field['id']),
                    $checked
                );
                break;
            case 'select':
                $pages = get_pages(); // Fetch all pages
                $posts = get_posts(array('numberposts' => -1)); // Fetch all posts

                echo sprintf('<select name="%1$s" id="%1$s">', esc_attr($field['id']));
                echo '<option value="">' . esc_html__('Select a page/post', 'frontend-ajax-login-register') . '</option>';

                // Display pages in the dropdown
                foreach ($pages as $page) {
                    $selected = selected($value, $page->ID, false);
                    echo sprintf(
                        '<option value="%1$s" %2$s>%3$s (Page)</option>',
                        esc_attr($page->ID),
                        $selected,
                        esc_html($page->post_title)
                    );
                }

                // Display posts in the dropdown
                foreach ($posts as $post) {
                    $selected = selected($value, $post->ID, false);
                    echo sprintf(
                        '<option value="%1$s" %2$s>%3$s (Post)</option>',
                        esc_attr($post->ID),
                        $selected,
                        esc_html($post->post_title)
                    );
                }

                echo '</select>';

                //---- Start Logout Redirect----


                //---- End   Logout Redirect----

                break;
            case 'text':
            default:
                echo sprintf(
                    '<input name="%1$s" id="%1$s" type="%2$s" value="%3$s" class="my-color-field" data-default-color="%3$s" />',
                    esc_attr($field['id']),
                    esc_attr($field['type']),
                    esc_attr($value)
                );
                break;
        }

        if (!empty($field['desc'])) {
            printf('<p class="description">%s</p>', esc_html($field['desc']));
        }
    }
}
new falr_Settings_Page();
