<?php
/*
 * Plugin Name:       Frontend Ajax Login & Register
 * Plugin URI:        https://wordpress.org/plugins/frontend-ajax-login-register
 * Description:       Ajax frontend login register.
 * Tags:              responsive, images, responsive images, disable, srcset
 * Version:           1.2
 * Requires at least: 5.2
 * Requires PHP:      7.2
 * Author:            Logicrays
 * Author URI:        http://logicrays.com/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI:        https://wordpress.org/plugins/frontend-ajax-login-register
 * Text Domain:       frontend-ajax-login-register
 * Domain Path:       /languages
 */



if (! defined('ABSPATH')) {
    exit;
}

ini_set('allow_url_fopen', 1);

if (! defined('LR_DIR_PATH')) {
    define('LR_DIR_PATH', plugin_dir_path(__FILE__));
}
if (! defined('LR_DIR_URL')) {
    define('LR_DIR_URL', plugin_dir_url(__FILE__));
}
if (! defined('LR_BASE_NAME')) {
    define('LR_BASE_NAME', plugin_basename(__FILE__));
}

class LR_Ajax_Login_Register
{

    public function __construct()
    {
        add_action('init', array($this, 'falr_auth_init'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts_and_styles'));
        add_action('wp_ajax_nopriv_ajaxlogin', array($this, 'falr_login'));
        add_action('wp_ajax_nopriv_ajaxregister', array($this, 'falr_register'));
        add_action('wp_ajax_nopriv_ajaxforgotpassword', array($this, 'falr_forgotPassword'));

        add_action('show_user_profile', array($this, 'falr_show_contact_number_field'));
        add_action('edit_user_profile', array($this, 'falr_show_contact_number_field'));

        add_action('personal_options_update', array($this, 'falr_save_contact_number_field'));
        add_action('edit_user_profile_update', array($this, 'falr_save_contact_number_field'));
    }

    public function falr_auth_init()
    {
        wp_register_style('ajax-auth-style', LR_DIR_URL . 'css/ajax-auth-style.css', array(), '1.0.0', 'all');
        wp_register_script('validate-script', LR_DIR_URL . 'js/jquery.validate.js', array('jquery'), '1.19.2', true);
        wp_register_script('ajax-auth-script', LR_DIR_URL . 'js/ajax-auth-script.js', array('jquery'), '1.0.0', true);

        // Localize the script with new data
        $get_page_id = get_option('redirect_after_login');
        global $reidicect;

        if (!empty($get_page_id)) {
            $reidicect =  get_permalink($get_page_id);
        } else {
            $reidicect =  home_url();
        }
        wp_localize_script('ajax-auth-script', 'ajax_auth_object', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'redirecturl' => $reidicect,
            'loadingmessage' => __('Sending user info, please wait...', 'frontend-ajax-login-register')
        ));
        wp_enqueue_script('ajax-auth-script');
    }

    public function enqueue_scripts_and_styles()
    {
        // Enqueue the styles and scripts
        wp_enqueue_style('ajax-auth-style');
        wp_enqueue_script('validate-script');
    }

    public function falr_login()
    {
        // First check the nonce, if it fails the function will break
        check_ajax_referer('ajax-login-nonce', 'security');

        // Nonce is checked, get the POST data and sign user on
        // Call falr_auth_user_login method
        $this->falr_auth_user_login($_POST['username'], $_POST['password'], 'Login');
        die();
    }

    public function falr_register()
    {
        // First check the nonce, if it fails the function will break
        check_ajax_referer('ajax-register-nonce', 'security');


        // Nonce is checked, get the POST data and sign user on
        $info = array();
        $info['user_nicename'] = $info['nickname'] = $info['display_name'] = $info['first_name'] = $info['user_login'] = sanitize_user($_POST['username']);
        $info['user_pass'] = sanitize_text_field($_POST['password']);
        $info['user_email'] = sanitize_email($_POST['email']);

        // Check if contact number is set and sanitize it
        if (isset($_POST['contactno']) && !empty($_POST['contactno'])) {
            $info['user_contact_no'] = sanitize_text_field($_POST['contactno']);
        } else {
            $info['user_contact_no'] = ''; // Set a default blank value if not provided
        }

        // Register the user
        $user_register = wp_insert_user($info);

        if (is_wp_error($user_register)) {
            $error  = $user_register->get_error_codes();

            if (in_array('empty_user_login', $error)) {
                echo json_encode(array('loggedin' => false, 'message' => __($user_register->get_error_message('empty_user_login'))));
            } elseif (in_array('existing_user_login', $error)) {
                echo json_encode(array('loggedin' => false, 'message' => __('This username is already registered.')));
            } elseif (in_array('existing_user_email', $error)) {
                echo json_encode(array('loggedin' => false, 'message' => __('This email address is already registered.')));
            }
        } else {
            // Store contact number in user meta only if it's not empty
            if (!empty($info['user_contact_no'])) {
                $meta_update = update_user_meta($user_register, 'user_contact_no', $info['user_contact_no']);
            }

            // Optionally log the user in after registration
            // $this->falr_auth_user_login($info['nickname'], $info['user_pass'], 'Registration');
            echo json_encode(array('loggedin' => true, 'message' => __('Successful Registration.')));
        }
        die();
    }



    public function falr_auth_user_login($user_login, $password, $login)
    {
        $info = array();
        $info['user_login'] = $user_login;
        $info['user_password'] = $password;
        $info['remember'] = true;

        $user_signon = wp_signon($info, '');
        if (is_wp_error($user_signon)) {
            echo json_encode(array('loggedin' => false, 'message' => __('Wrong username or password.')));
        } else {
            wp_set_current_user($user_signon->ID);
            echo json_encode(array('loggedin' => true, 'message' => __($login . ' successful, redirecting...')));
        }
        die();
    }

    public function falr_forgotPassword()
    {
        // First check the nonce, if it fails the function will break
        check_ajax_referer('ajax-forgot-nonce', 'security');

        global $wpdb;

        $account = $_POST['user_login'];

        if (empty($account)) {
            $error = 'Enter an username or e-mail address.';
        } else {
            if (is_email($account)) {
                if (email_exists($account))
                    $get_by = 'email';
                else
                    $error = 'There is no user registered with that email address.';
            } elseif (validate_username($account)) {
                if (username_exists($account))
                    $get_by = 'login';
                else
                    $error = 'There is no user registered with that username.';
            } else {
                $error = 'Invalid username or e-mail address.';
            }
        }

        if (empty($error)) {
            // Generate new password
            $random_password = wp_generate_password();

            // Get user data by field and data
            $user = get_user_by($get_by, $account);

            $update_user = wp_update_user(array('ID' => $user->ID, 'user_pass' => $random_password));

            // Send email containing the new password
            if ($update_user) {
                $from = get_option('admin_email'); // Set whatever you want like mail@yourdomain.com

                if (!(isset($from) && is_email($from))) {
                    $sitename = strtolower($_SERVER['SERVER_NAME']);
                    if (substr($sitename, 0, 4) == 'www.') {
                        $sitename = substr($sitename, 4);
                    }
                    $from = 'admin@' . $sitename;
                }

                $to = $user->user_email;
                $subject = 'Your new password';
                $sender = 'From: ' . get_option('name') . ' <' . $from . '>' . "\r\n";

                $message = 'Your new password is: ' . $random_password;

                $headers[] = 'MIME-Version: 1.0' . "\r\n";
                $headers[] = 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
                $headers[] = "X-Mailer: PHP \r\n";
                $headers[] = $sender;

                $mail = wp_mail($to, $subject, $message, $headers);
                if ($mail) {
                    $success = 'Check your email address for your new password.';
                } else {
                    $error = 'System is unable to send you an email containing your new password.';
                }
            } else {
                $error = 'Oops! Something went wrong while updating your account.';
            }
        }

        if (!empty($error)) {
            echo json_encode(array('loggedin' => false, 'message' => __($error)));
        }

        if (!empty($success)) {
            echo json_encode(array('loggedin' => false, 'message' => __($success)));
        }

        die();
    }
    // Add the custom field to the user profile page
    public function falr_show_contact_number_field($user)
    {
        if (!empty(esc_attr(get_user_meta($user->ID, 'user_contact_no', true)))) {
?>
            <h3><?php _e('Additional Information', 'your_text_domain'); ?></h3>
            <table class="form-table">
                <tr>
                    <th><label for="contactno"><?php _e('Contact Number', 'your_text_domain'); ?></label></th>
                    <td>
                        <input type="text" name="contactno" id="contactno" value="<?php echo esc_attr(get_user_meta($user->ID, 'user_contact_no', true)); ?>" class="regular-text" /><br />
                        <span class="description"><?php _e('Please enter your contact number.', 'your_text_domain'); ?></span>
                    </td>
                </tr>
            </table>
<?php
        }
    }
    // Save the custom field data
    function falr_save_contact_number_field($user_id)
    {
        // Check if current user has the capability to edit user profile
        if (!current_user_can('edit_user', $user_id)) {
            return false;
        }

        // Update user meta for contact number
        if (isset($_POST['contactno'])) {
            update_user_meta($user_id, 'user_contact_no', sanitize_text_field($_POST['contactno']));
        }
    }
}

new LR_Ajax_Login_Register();


require_once LR_DIR_PATH . 'includes/frontend-ajax-login-register-shortcode.php';

if (is_admin()) {
    require_once LR_DIR_PATH . 'includes/frontend-ajax-login-register-settings.php';
}
