<?php
/**
 * Uninstall Fresh Install Assistant
 *
 * @package Fresh_Install_Assistant
 */

// Exit if uninstall not called from WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove any transients
delete_transient('fresh_install_assistant_activation_redirect');

// Remove user meta for hidden dashboard widgets if needed
$users = get_users();
foreach ($users as $user) {
    $hidden_widgets = get_user_meta($user->ID, 'metaboxhidden_dashboard', true);
    if (is_array($hidden_widgets)) {
        // Remove any widgets that were hidden by our plugin
        // Since we can't track which ones we hid vs user hid, we leave them as is
        // This is the safest approach
    }
}

// Note: We don't need to clean up pages, menus, or other content
// as those are legitimate site content that should remain