<?php
/**
 * Setup page template
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap fresh-install-assistant-wrap">
    <h1><?php esc_html_e('Fresh Install Assistant (FIA) Setup', 'fresh-install-assistant'); ?></h1>
    
    <div id="fresh-install-assistant-setup-form" class="fresh-install-assistant-form">
        <p class="description">
            <?php esc_html_e('Select the tasks you want to perform. All cleanup and setup tasks are selected by default.', 'fresh-install-assistant'); ?>
        </p>
        
        <form id="fresh-install-assistant-form" method="post">
            <?php wp_nonce_field('fresh_install_assistant_setup', 'fresh_install_assistant_nonce'); ?>
            
            <!-- Essential Cleanup Section -->
            <div class="fresh-install-assistant-section">
                <h2>
                    <?php esc_html_e('Essential Cleanup', 'fresh-install-assistant'); ?>
                    <span class="toggle-all">
                        <label>
                            <input type="checkbox" class="select-all" data-section="cleanup" checked>
                            <?php esc_html_e('Select All', 'fresh-install-assistant'); ?>
                        </label>
                    </span>
                </h2>
                
                <div class="fresh-install-assistant-tasks">
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="remove_hello_world" checked>
                        <?php esc_html_e('Remove "Hello World" post', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="remove_sample_page" checked>
                        <?php esc_html_e('Remove "Sample Page"', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="rename_uncategorized" checked>
                        <?php esc_html_e('Change "Uncategorized" category to "Blog"', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="set_permalinks" checked>
                        <?php esc_html_e('Set permalink structure to /%postname%/', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="remove_hello_dolly" checked>
                        <?php esc_html_e('Remove "Hello Dolly" plugin', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="remove_akismet" checked>
                        <?php esc_html_e('Remove "Akismet" plugin', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="disable_comments" checked>
                        <?php esc_html_e('Disable comments and pingbacks', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="cleanup_tasks[]" value="hide_dashboard_widgets" checked>
                        <?php esc_html_e('Hide dashboard widgets (Quick Draft, At a Glance, etc.)', 'fresh-install-assistant'); ?>
                    </label>
                </div>
            </div>
            
            <!-- Initial Site Setup Section -->
            <div class="fresh-install-assistant-section">
                <h2>
                    <?php esc_html_e('Initial Site Setup', 'fresh-install-assistant'); ?>
                    <span class="toggle-all">
                        <label>
                            <input type="checkbox" class="select-all" data-section="setup" checked>
                            <?php esc_html_e('Select All', 'fresh-install-assistant'); ?>
                        </label>
                    </span>
                </h2>
                
                <div class="fresh-install-assistant-tasks">
                    <label>
                        <input type="checkbox" name="setup_tasks[]" value="set_site_info" checked>
                        <?php esc_html_e('Set site title and tagline', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <div class="site-info-fields" style="margin-left: 25px; margin-bottom: 15px;">
                        <p>
                            <input type="text" name="site_title" id="site_title" class="regular-text" placeholder="<?php esc_attr_e('Site Title', 'fresh-install-assistant'); ?>" value="<?php echo esc_attr(get_bloginfo('name')); ?>" />
                        </p>
                        <p>
                            <input type="text" name="site_tagline" id="site_tagline" class="regular-text" placeholder="<?php esc_attr_e('Tagline', 'fresh-install-assistant'); ?>" value="<?php echo esc_attr(get_bloginfo('description')); ?>" />
                        </p>
                    </div>
                    
                    <label>
                        <input type="checkbox" name="setup_tasks[]" value="create_pages" checked>
                        <?php esc_html_e('Create starter pages', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <div class="pages-selection" style="margin-left: 25px; margin-bottom: 15px;">
                        <label style="font-weight: normal;">
                            <input type="checkbox" name="pages_to_create[]" value="home" class="page-checkbox" checked>
                            <?php esc_html_e('Home', 'fresh-install-assistant'); ?>
                        </label>
                        <label style="font-weight: normal;">
                            <input type="checkbox" name="pages_to_create[]" value="services" class="page-checkbox" checked>
                            <?php esc_html_e('Services', 'fresh-install-assistant'); ?>
                        </label>
                        <label style="font-weight: normal;">
                            <input type="checkbox" name="pages_to_create[]" value="about" class="page-checkbox" checked>
                            <?php esc_html_e('About', 'fresh-install-assistant'); ?>
                        </label>
                        <label style="font-weight: normal;">
                            <input type="checkbox" name="pages_to_create[]" value="contact" class="page-checkbox" checked>
                            <?php esc_html_e('Contact', 'fresh-install-assistant'); ?>
                        </label>
                        <label style="font-weight: normal;">
                            <input type="checkbox" name="pages_to_create[]" value="blog" class="page-checkbox" checked>
                            <?php esc_html_e('Blog', 'fresh-install-assistant'); ?>
                        </label>
                    </div>
                    
                    <label>
                        <input type="checkbox" name="setup_tasks[]" value="set_front_page" checked>
                        <?php esc_html_e('Set Home page as front page', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="setup_tasks[]" value="set_blog_page" checked>
                        <?php esc_html_e('Set Blog page as posts page', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="checkbox" name="setup_tasks[]" value="create_menu" checked>
                        <?php esc_html_e('Create main navigation menu', 'fresh-install-assistant'); ?>
                    </label>
                </div>
            </div>
            
            <!-- Theme Installation Section -->
            <div class="fresh-install-assistant-section">
                <h2><?php esc_html_e('Theme Installation', 'fresh-install-assistant'); ?></h2>
                <p class="description">
                    <?php esc_html_e('Optionally install and activate one of these popular themes:', 'fresh-install-assistant'); ?>
                </p>
                
                <div class="fresh-install-assistant-tasks theme-selection">
                    <label>
                        <input type="radio" name="theme_task" value="none" checked>
                        <?php esc_html_e('Skip theme installation', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="astra">
                        <?php esc_html_e('Astra', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="generatepress">
                        <?php esc_html_e('GeneratePress', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="oceanwp">
                        <?php esc_html_e('OceanWP', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="blocksy">
                        <?php esc_html_e('Blocksy', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="neve">
                        <?php esc_html_e('Neve', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="hello-elementor">
                        <?php esc_html_e('Hello Elementor', 'fresh-install-assistant'); ?>
                    </label>
                    
                    <label>
                        <input type="radio" name="theme_task" value="kadence">
                        <?php esc_html_e('Kadence', 'fresh-install-assistant'); ?>
                    </label>
                </div>
            </div>
            
            <p class="submit">
                <button type="submit" class="button button-primary button-large" id="fresh-install-assistant-run">
                    <?php esc_html_e('Run Setup', 'fresh-install-assistant'); ?>
                </button>
            </p>
        </form>
    </div>
    
    <!-- Progress Section (hidden initially) -->
    <div id="fresh-install-assistant-progress" style="display: none;">
        <div class="fresh-install-assistant-section">
            <h2><?php esc_html_e('Processing Tasks', 'fresh-install-assistant'); ?></h2>
            <div style="display: flex; align-items: center; gap: 10px; padding: 10px 0;">
                <span class="spinner is-active" style="float: none; margin: 0;"></span>
                <span id="progress-text"><?php esc_html_e('Running setup tasks...', 'fresh-install-assistant'); ?></span>
            </div>
        </div>
    </div>
    
    <!-- Results Section (hidden initially) -->
    <div id="fresh-install-assistant-results" style="display: none;">
        <div id="fresh-install-assistant-results-content"></div>
        
        <div id="fresh-install-assistant-complete" style="display: none;">
            <div class="fresh-install-assistant-section">
                <h3><?php esc_html_e('Setup Complete!', 'fresh-install-assistant'); ?></h3>
                <p id="deactivation-message">
                    <?php esc_html_e('Deactivating plugin...', 'fresh-install-assistant'); ?>
                </p>
                <p class="submit">
                    <a href="<?php echo esc_url(admin_url()); ?>" class="button button-primary">
                        <?php esc_html_e('Go to Dashboard', 'fresh-install-assistant'); ?>
                    </a>
                    <a href="<?php echo esc_url(admin_url('plugins.php')); ?>" class="button button-secondary">
                        <?php esc_html_e('Go to Plugins', 'fresh-install-assistant'); ?>
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>