<?php
/**
 * Main plugin class
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

class Fresh_Install_Assistant {
    
    /**
     * Plugin instance
     */
    private static $instance = null;
    
    /**
     * Setup handler instance
     */
    private $setup_handler;
    
    /**
     * Get singleton instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        $this->load_dependencies();
        $this->init_hooks();
    }
    
    /**
     * Load required dependencies
     */
    private function load_dependencies() {
        require_once FRESH_INSTALL_ASSISTANT_PLUGIN_DIR . 'includes/class-setup-handler.php';
        require_once FRESH_INSTALL_ASSISTANT_PLUGIN_DIR . 'includes/tasks/class-cleanup-tasks.php';
        require_once FRESH_INSTALL_ASSISTANT_PLUGIN_DIR . 'includes/tasks/class-setup-tasks.php';
        require_once FRESH_INSTALL_ASSISTANT_PLUGIN_DIR . 'includes/tasks/class-theme-tasks.php';
    }
    
    /**
     * Initialize hooks
     */
    private function init_hooks() {
        // Initialize setup handler
        $this->setup_handler = new Fresh_Install_Assistant_Setup_Handler();
        
        // Add admin menu
        add_action('admin_menu', array($this, 'add_admin_menu'));
        
        // Enqueue admin scripts and styles
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
    }
    
    /**
     * Run the plugin
     */
    public function run() {
        // Plugin is initialized through hooks
    }
    
    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_menu_page(
            __('Fresh Install Assistant (FIA) Setup', 'fresh-install-assistant'),
            __('Fresh Install Assistant (FIA)', 'fresh-install-assistant'),
            'manage_options',
            'fresh-install-assistant-setup',
            array($this->setup_handler, 'render_setup_page'),
            'dashicons-admin-tools',
            100
        );
    }
    
    /**
     * Enqueue admin assets
     */
    public function enqueue_admin_assets($hook) {
        // Only load on our plugin page
        if ('toplevel_page_fresh-install-assistant-setup' !== $hook) {
            return;
        }
        
        // Enqueue CSS
        wp_enqueue_style(
            'fresh-install-assistant-admin',
            FRESH_INSTALL_ASSISTANT_PLUGIN_URL . 'assets/css/admin.css',
            array(),
            FRESH_INSTALL_ASSISTANT_VERSION
        );
        
        // Enqueue JavaScript
        wp_enqueue_script(
            'fresh-install-assistant-admin',
            FRESH_INSTALL_ASSISTANT_PLUGIN_URL . 'assets/js/admin.js',
            array('jquery'),
            FRESH_INSTALL_ASSISTANT_VERSION,
            true
        );
        
        // Localize script for AJAX
        wp_localize_script('fresh-install-assistant-admin', 'freshInstallAssistant', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('fresh_install_assistant_nonce'),
            'strings' => array(
                'processing' => __('Processing...', 'fresh-install-assistant'),
                'completed' => __('Completed', 'fresh-install-assistant'),
                'failed' => __('Failed', 'fresh-install-assistant'),
                'skipped' => __('Skipped', 'fresh-install-assistant'),
                'deactivated' => __('The plugin has been deactivated. You can now safely delete it from the Plugins page.', 'fresh-install-assistant'),
                'selectAll' => __('Select All', 'fresh-install-assistant')
            )
        ));
    }
}