<?php
/**
 * Plugin Name: Fresh Install Assistant (FIA)
 * Plugin URI: https://wordpress.org/plugins/fresh-install-assistant/
 * Description: Automates WordPress initial setup by cleaning default content, creating essential pages, and optionally installing popular themes
 * Version: 1.0.3
 * Author: Thushara Lakshan
 * Author URI: https://profiles.wordpress.org/lakshan12/ 
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: fresh-install-assistant
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('FRESH_INSTALL_ASSISTANT_VERSION', '1.0.3');
define('FRESH_INSTALL_ASSISTANT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FRESH_INSTALL_ASSISTANT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FRESH_INSTALL_ASSISTANT_PLUGIN_FILE', __FILE__);

// Plugin activation hook
register_activation_hook(__FILE__, 'fresh_install_assistant_activate');

function fresh_install_assistant_activate() {
    // Set a transient to trigger redirect
    set_transient('fresh_install_assistant_activation_redirect', true, 30);
}

// Plugin deactivation hook
register_deactivation_hook(__FILE__, 'fresh_install_assistant_deactivate');

function fresh_install_assistant_deactivate() {
    // Clean up transients
    delete_transient('fresh_install_assistant_activation_redirect');
}

// Load the main plugin class
require_once FRESH_INSTALL_ASSISTANT_PLUGIN_DIR . 'includes/class-fresh-install-assistant.php';

// Initialize the plugin
function fresh_install_assistant_init() {
    $plugin = Fresh_Install_Assistant::get_instance();
    $plugin->run();
}
add_action('plugins_loaded', 'fresh_install_assistant_init');

// Handle activation redirect
add_action('admin_init', 'fresh_install_assistant_activation_redirect');

function fresh_install_assistant_activation_redirect() {
    // Only redirect if the transient is set and we're not already on the setup page
    if (get_transient('fresh_install_assistant_activation_redirect')) {
        delete_transient('fresh_install_assistant_activation_redirect');
        
        // Don't redirect during bulk activation or if doing AJAX
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Checking for bulk activation doesn't require nonce
        if (!isset($_GET['activate-multi']) && !wp_doing_ajax()) {
            wp_safe_redirect(admin_url('admin.php?page=fresh-install-assistant-setup'));
            exit;
        }
    }
}