( function($) {
	"use strict";


	/**************************
	 * Tabs
	 * ************************/
	$( '.frequentlybuy-tab' ).on( 'click', function(e) {
 		e.preventDefault();

		let $selector = $(this).attr('id'),
			$contentWrap = $('.frequentlybuy-meta-tabs-content-area');

			console.log($selector);

		$('#'+$selector).closest('.frequentlybuy-meta-tabs').find('.frequentlybuy-active').removeClass('frequentlybuy-active');
		$('#'+$selector).addClass('frequentlybuy-active');
		
		$contentWrap.find('.frequentlybuy-active').removeClass('frequentlybuy-active').addClass('frequentlybuy-hide');
		$('[data-tabref="'+$selector+'"]').removeClass('frequentlybuy-hide').addClass('frequentlybuy-active');
		

	} );


	/**************************
	 * Color Picker
	 * *************************/
	$('.color-field').wpColorPicker();

	/**************************
	 * Media Upload
	 * ************************/
	var mediaUploader, t;

	$('.frequentlybuy_image_upload_btn').on( 'click', function(e) {

		e.preventDefault();

		t = $(this).parent().find('.frequentlybuy_background_image');

		if (mediaUploader) {
		  mediaUploader.open();
		  return;
		}
		mediaUploader = wp.media.frames.file_frame = wp.media({
		  title: 'Choose Image',
		  button: {
		  text: 'Choose Image'
		}, multiple: false });
		mediaUploader.on('select', function() {
		var attachment = mediaUploader.state().get('selection').first().toJSON();

			t.val( attachment.url )

		});
		mediaUploader.open();
	});


	/**************************
	 * conditional fields
	 * ************************/

    $('[data-condition]').each( function( i, item ) {

        let $item =  $(item).data('condition');
        
        $.each( $item, function( i, val ) {

            // type Switch 
            let s = $( '[name="'+i+'"]' );


            switch( s.attr('type') ) {

                case 'checkbox':
                    // On click
                    s.on( 'click', function() {
                
                        let t = $(this).is(':checked') == true ? 'yes' : '';

                        if( $(this).val() == t ) {
                            $(item).fadeIn();
                        } else {
                            $(item).fadeOut();
                        }
                        
                    } )
                    // On load 
                    if( s.is(':checked') != false ) {
                        $(item).fadeIn();
                    } else {
                        $(item).fadeOut();
                    }
                break;
                default:
                    // On change
                    s.on( 'change', function() {

                        if( $.inArray( $(this).val(), val ) != -1 ) {
                            $(item).fadeIn();
                        } else {
                            $(item).fadeOut();
                        }
                        
                    } )
                    // On load
                    if( $.inArray( s.val(), val ) != -1 ) {
                        $(item).fadeIn();
                    } else {
                        $(item).fadeOut();
                    }
                break;

            }
            
        } )

    } )

    /**************************
	 * Select2
	 * *************************/

    $('.frequentlybuy-meta-multiple-select').each(function () {
        $(this).select2({
            maximumSelectionLength: $(this).data('maxselect')
        });
    });

} )(jQuery);