<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Text {

    public function text_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'value' => '',
            'placeholder' => '',
            'description' => '',
            'condition'   => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->text_markup( $args );
    }

    public function text_markup( $args ) {

        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <div class="input-field-block">
                <input type="text" class="input-control" placeholder="<?php echo esc_html( $args['placeholder'] ); ?>" name="<?php echo esc_attr( $args['name'] ); ?>" value="<?php echo esc_html( $args['value'] ); ?>"/>
                <?php
                if( !empty( $args['description'] ) ) {
                    echo '<p>'.wp_kses_post( $args['description'] ).'</p>';
                }
                ?>
            </div>
        </div>
        <?php
    }
}