<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Select {

    public function select_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'placeholder' => '',
            'options' => [],
            'condition' => '',
            'value'     => '',
            'description' => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->select_markup( $args );
    }

    public function select_markup( $args ) {
        $fieldName = $args['name'];
        $value = !empty( $args['value'] ) ? $args['value'] : '';
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <div>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <?php
            if( !empty( $args['description'] ) ) {
                echo '<p>'.esc_html( $args['description'] ).'</p>';
            }
            ?>
            </div>
            
            <select class="input-control" name="<?php echo esc_attr( $fieldName ); ?>">
                <?php 
                if( !empty( $args['options'] ) ) {
                    foreach( $args['options'] as $key => $opt ) {
                        echo '<option value="'.esc_attr( $key ).'" '.selected( $key, $value, false ).'>'.esc_html( $opt ).'</option>';
                    }
                }
                ?>
            </select>
        </div>
        <?php
    }
    
}