<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Media {

    public function media_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'value' => '',
            'condition'   => '',
            'description' => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->media_markup( $args );
    }

    public function media_markup( $args ) {
        
        $value = !empty( $args['value'] ) ? $args['value'] : '';
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <div>
                <?php
                if( !empty( $args['description'] ) ) {
                    echo '<p>'.esc_html( $args['description'] ).'</p>';
                }
                ?>
            <input class="frequentlybuy_background_image" type="text" name="<?php echo esc_attr( $args['name'] ); ?>" value="<?php echo esc_attr( $value ); ?>" />
            <input type="button" class="frequentlybuy_image_upload_btn button-primary" value="<?php esc_html_e( 'Upload', 'frequentlybuy' ) ?>" />
            
            </div>
        </div>
        <?php
    }
}