<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Image_Radio_Button {

  public static $args;

  public function image_radio_field( $args ) {
    
    $default = [
      'title' => '',
      'name' => '',
      'options' => [],
      'placeholder' => '',
      'description' => '',
      'value' => '',
      'condition'   => '',
      'is_pro'      => ''
    ];

    $args = wp_parse_args( $args, $default );
    $this->image_radio_markup( $args );

  }

	public  function image_radio_markup( $args ) {

    $value = !empty( $args['value'] ) ? $args['value'] : '';
    $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
    ?>
    <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
        <?php
        if( !empty( $args['is_pro'] ) ) {
            echo '<span class="pro-badge">PRO</span>';
        }
        ?>
        <h3><?php echo esc_html( $args['title'] ); ?></h3>
        <div class="input-field-block">
            <div class="frequentlybuy-img-button-switch">
            <?php
            foreach( $args['options'] as $key => $url ) {
              echo '<label class="radio-img"><input type="radio" name="'.esc_attr( $args['name'] ).'" '.checked(  $value,$key,false ).' value="'.esc_attr( $key ).'" /><img src="'.esc_url( $url ).'"></label>';
            }
            ?>
            </div>
            <p><?php echo wp_kses_post( $args['description'] ); ?></p>
        </div>
    </div>
    <?php

	}

}  
