<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Heading {

    public function heading_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'placeholder' => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->heading_markup( $args );
    }

    public function heading_markup( $args ) {
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp block-heading">
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
        </div>
        <?php
    }
}