<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

if( !defined( 'WPINC' ) ) {
    die;
}

class Fields_Maping {

    use Text;
    use Color;
    use Media;
    use Switcher;
    use Heading;
    use Dimension;
    use Number;
    use Border;
    use Select;
    use Box_Shadow;
    use Image_Radio_Button;
    use Border_Radius;
    use Multiple_Select;
    use Radio_Button;

    public function get_name() {
        return '';
    }

    public function scripts() {
        add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
    }

    public function enqueue_scripts( $hook ) {

            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_media();
            wp_enqueue_style( 'jquery-ui', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/css/jquery-ui.css', array(), \FREQUENTLYBUY_VERSION, false );
            wp_enqueue_style( 'select2-min', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/css/select2.min.css', array(), \FREQUENTLYBUY_VERSION, false );
            wp_enqueue_style( 'frequentlybuy-fields', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/css/fields.css', array(), \FREQUENTLYBUY_VERSION, false  );

            //
            if ( !\FrequentlyBuy\Inc\Helper::is_pro_active() && get_current_screen()->post_type == 'frequentlybuy' && \FrequentlyBuy\Inc\Helper::get_frequently_count() >= 1 ) {

                $custom_css = "
                    .page-title-action { display: none !important; }";
                wp_add_inline_style( 'frequentlybuy-fields', $custom_css );
            }

            wp_enqueue_script( 'wp-color-picker-alpha', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/js/wp-color-picker-alpha.js', array('jquery', 'wp-color-picker' ), \FREQUENTLYBUY_VERSION, true );
            wp_enqueue_script( 'select2-min', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/js/select2.min.js', array('jquery'), \FREQUENTLYBUY_VERSION, true );
            wp_enqueue_script( 'frequentlybuy-fields', \FREQUENTLYBUY_DIR_URL.'/meta-fields/assets/js/fields.js', array('jquery', 'wp-color-picker','jquery-ui-slider' ), \FREQUENTLYBUY_VERSION, true );
        
    }

}
