<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Color {

    public function color_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'placeholder' => '',
            'condition'   => '',
            'value' => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->color_markup( $args );
    }

    public function color_markup( $args ) {
        $fieldName = esc_attr( $args['name'] );
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <input type="text" id="bg_color" class="color-field" data-alpha-enabled="true" data-alpha-color-type="rgb" placeholder="<?php echo esc_html( $args['placeholder'] ); ?>" value="<?php echo esc_html( $args['value'] ); ?>" name="<?php echo esc_attr( $fieldName ); ?>" />
        </div>
        <?php
    }

}