<?php
namespace FrequentlyBuy\Metafields;
/**
 * 
 *
 * @package     FrequentlyBuy
 * @author      ThemeLooks
 * @copyright   2022 ThemeLooks
 * @license     GPL-2.0-or-later
 *
 *
 */

trait Box_Shadow {

    public function box_shadow_field( $args ) {

        $default = [
            'title' => '',
            'name' => '',
            'value' => '',
            'placeholder' => '',
            'condition'   => '',
            'is_pro'      => ''
        ];

        $args = wp_parse_args( $args, $default );
        $this->box_shadow_markup( $args );
    }

    public function box_shadow_markup( $args ) {

        $value = $args['value'];

        $fieldName = $args['name'];
        $condition = !empty( $args['condition'] ) ? 'data-condition='.wp_json_encode( $args['condition'] ) : '';


        $horizontal = !empty( $value['horizontal'] ) ? $value['horizontal'] : '';
        $vertical   = !empty( $value['vertical'] ) ? $value['vertical'] : '';
        $blur       = !empty( $value['blur'] ) ? $value['blur'] : '';
        $spread     = !empty( $value['spread'] ) ? $value['spread'] : '';
        $color      = !empty( $value['color'] ) ? $value['color'] : '';
        ?>
        <div class="frequentlybuy-label frequentlybuy-<?php echo esc_attr( $fieldName ); ?> frequentlybuy-field-wrp" <?php echo esc_attr( $condition ); ?>>
            <?php
            if( !empty( $args['is_pro'] ) ) {
                echo '<span class="pro-badge">PRO</span>';
            }
            ?>
            <h3><?php echo esc_html( $args['title'] ); ?></h3>
            <div class="dimension-input-group">
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Horizontal Length', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" placeholder="Horizontal" name="<?php echo esc_attr( $fieldName.'[horizontal]' ); ?>" value="<?php echo esc_html( $horizontal ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Vertical Length', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" placeholder="Vertical" name="<?php echo esc_attr( $fieldName.'[vertical]' ); ?>" value="<?php echo esc_html( $vertical ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Blur Radius', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" placeholder="Bottom" name="<?php echo esc_attr( $fieldName.'[blur]' ); ?>" value="<?php echo esc_html( $blur ); ?>"/>
                </div>
                <div class="dimension-field-wrap">
                <span><?php esc_html_e( 'Spread Radius', 'frequentlybuy' ); ?></span>
                <input type="number" class="dimension-field" placeholder="Left" name="<?php echo esc_attr( $fieldName.'[spread]' ); ?>" value="<?php echo esc_html( $spread ); ?>"/>
                </div>
                <div class="border-field-wrap bs-color-field-wrap">
                    <span class="bs-color-field-wrap"><?php esc_html_e( 'Color', 'frequentlybuy' ); ?></span>
                    <input type="text" id="bg_color" data-alpha-enabled="true" data-alpha-color-type="rgb" class="color-field" value="<?php echo esc_html( $color ); ?>" name="<?php echo esc_attr( $fieldName ); ?>[color]" />
                </div>
            </div>
        </div>
        <?php
    }
}